using System;
using System.Collections.Generic;

class Program
{
    struct Runner
    {
        public long x, y, dx, dy;
        public Runner(long x, long y, long dx, long dy)
        {
            this.x = x; this.y = y; this.dx = dx; this.dy = dy;
        }
    }
    
    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        List<(long, long)> points = new List<(long, long)>();
        
        for (int i = 0; i < n; i++)
        {
            var parts = Console.ReadLine().Split();
            long x = long.Parse(parts[0]);
            long y = long.Parse(parts[1]);
            points.Add((x, y));
        }
        
    
        List<Runner> runners = new List<Runner>();
        foreach (var (x, y) in points)
        {
            runners.Add(new Runner(x, y, 1, 0));   // ?????
            runners.Add(new Runner(x, y, -1, 0));  // ???
            runners.Add(new Runner(x, y, 0, 1));   // ?????
            runners.Add(new Runner(x, y, 0, -1));  // ?????
        }
        
        
        Dictionary<(long, long, long), int> meetings = new Dictionary<(long, long, long), int>();
        
        
        for (int i = 0; i < runners.Count; i++)
        {
            var r1 = runners[i];
            for (int j = i + 1; j < runners.Count; j++)
            {
                var r2 = runners[j];
                
                
                if (r1.dx == r2.dx && r1.dy == r2.dy)
                {
                    if (r1.x == r2.x && r1.y == r2.y)
                    {
                        
                        var key = (0L, r1.x, r1.y);
                        if (!meetings.ContainsKey(key)) meetings[key] = 0;
                        meetings[key]++;
                    }
                    continue;
                }
                
                
                long? t = null;
                
                if (r1.dx != r2.dx)
                {
                    long diff = r2.x - r1.x;
                    long denom = r1.dx - r2.dx;
                    if (diff % denom == 0)
                    {
                        long t_x = diff / denom;
                        if (t_x >= 0) t = t_x;
                    }
                }
                
                if (r1.dy != r2.dy)
                {
                    long diff = r2.y - r1.y;
                    long denom = r1.dy - r2.dy;
                    if (diff % denom == 0)
                    {
                        long t_y = diff / denom;
                        if (t_y >= 0)
                        {
                            if (t == null)
                                t = t_y;
                            else if (t != t_y)
                                continue; 
                        }
                    }
                }
                
                if (t.HasValue && t.Value >= 0)
                {
                    long pos_x = r1.x + t.Value * r1.dx;
                    long pos_y = r1.y + t.Value * r1.dy;
                    
                    
                    if (pos_x == r2.x + t.Value * r2.dx && 
                        pos_y == r2.y + t.Value * r2.dy)
                    {
                        var key = (t.Value, pos_x, pos_y);
                        if (!meetings.ContainsKey(key)) meetings[key] = 0;
                        meetings[key]++;
                    }
                }
            }
        }